<?php
header("Content-Type: application/json");
require_once("db.php"); // Include your database connection

$response = ["status" => "error", "message" => "Invalid request."];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);

    if (isset($data['shippingid'], $data['weights'], $data['weight_units']) &&
        !empty($data['shippingid']) &&
        is_array($data['weights']) &&
        is_array($data['weight_units']) &&
        count($data['weights']) === count($data['weight_units'])) {
        
        $shippingid = mysqli_real_escape_string($conn, $data['shippingid']);
        $insertedIds = [];

        // Loop through weights and weight_units to insert each as a new record
        for ($i = 0; $i < count($data['weights']); $i++) {
            $weight = mysqli_real_escape_string($conn, $data['weights'][$i]);
            $unit = mysqli_real_escape_string($conn, $data['weight_units'][$i]);

            $query = "INSERT INTO shipping_weight (shipping_id, weight, unit) VALUES ('$shippingid', '$weight', '$unit')";
            if (mysqli_query($conn, $query)) {
                $insertedIds[] = mysqli_insert_id($conn);
            }
        }

        if (!empty($insertedIds)) {
            $response = [
                "status" => "success",
                "inserted_ids" => implode(",", $insertedIds) // Comma-separated list of inserted IDs
            ];
        } else {
            $response = ["status" => "error", "message" => "No records inserted."];
        }
    } else {
        $response = ["status" => "error", "message" => "Invalid input format. Ensure shippingid, weights, and weight_units are provided and have matching lengths."];
    }
}

echo json_encode($response);
?>
